package gov.va.med.mhv.integration.phr.dao;

import gov.va.med.mhv.integration.phr.stage.transfer.StageAllergy;
import gov.va.med.mhv.integration.phr.stage.transfer.StageEntityAK;

import java.sql.SQLException;
import java.util.List;

public interface PhrAllergyDAO extends PhrBaseDAO {

	/**
	 * This method simply inserts the stage allergy object 
	 * into the stage_allergy table.
	 * 
	 * @param record
	 */
	public abstract void insertPHRAllergy(StageAllergy record);

	/**
	 * 
	 * @param icn
	 * @return
	 * @throws SQLException
	 */
	public abstract long deletePHRAllergy(String icn) throws SQLException;

	/**
	 * This method is responsible to transfer the new Allergy record into evault.
	 *
	 * It first updates the status to "NEW";
	 *
	 * @param ak
	 * @param records
	 * @return
	 * @throws SQLException
	 */
	public abstract int loadAllergy(StageEntityAK ak, List<StageAllergy> records)
			throws SQLException;

}